-- MySQL dump 9.11
--
-- Host: 127.0.0.1    Database: eve
-- ------------------------------------------------------
-- Server version	4.0.24

--
-- Table structure for table `account`
--

CREATE TABLE account (
  accountID int(10) unsigned NOT NULL auto_increment,
  accountName varchar(127) NOT NULL default '',
  password varchar(127) NOT NULL default '',
  role int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (accountID)
) TYPE=MyISAM;

--
-- Table structure for table `alliance_shortnames`
--

CREATE TABLE alliance_shortnames (
  allianceID int(10) unsigned NOT NULL default '0',
  shortName text NOT NULL,
  PRIMARY KEY  (allianceID)
) TYPE=MyISAM;

--
-- Table structure for table `billsReceivable`
--

CREATE TABLE billsReceivable (
  billID int(10) unsigned NOT NULL default '0',
  billTypeID int(10) unsigned default NULL,
  debtorID int(10) unsigned default NULL,
  creditorID int(10) unsigned default NULL,
  amount text NOT NULL,
  dueDateTime text NOT NULL,
  interest text NOT NULL,
  externalID int(10) unsigned default NULL,
  paid text NOT NULL,
  externalID2 text NOT NULL,
  PRIMARY KEY  (billID)
) TYPE=MyISAM;

--
-- Table structure for table `bookmarks`
--

CREATE TABLE bookmarks (
  bookmarkID int(10) unsigned NOT NULL default '0',
  ownerID int(10) unsigned NOT NULL default '0',
  itemID int(10) unsigned NOT NULL default '0',
  typeID int(10) unsigned NOT NULL default '0',
  flag int(10) unsigned NOT NULL default '0',
  memo varchar(255) NOT NULL default '',
  created int(10) unsigned NOT NULL default '0',
  x double NOT NULL default '0',
  y double NOT NULL default '0',
  z double NOT NULL default '0',
  locationID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (bookmarkID)
) TYPE=MyISAM;

--
-- Table structure for table `channelChars`
--

CREATE TABLE channelChars (
  channelID int(10) unsigned NOT NULL default '0',
  corpID int(10) unsigned NOT NULL default '0',
  charID int(10) unsigned NOT NULL default '0',
  allianceID int(10) unsigned NOT NULL default '0',
  role int(10) unsigned NOT NULL default '0',
  extra int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (channelID,charID)
) TYPE=MyISAM;

--
-- Table structure for table `channelMods`
--

CREATE TABLE channelMods (
  id int(10) unsigned NOT NULL auto_increment,
  channelID int(10) unsigned NOT NULL default '0',
  accessor int(10) unsigned default NULL,
  mode int(10) unsigned NOT NULL default '0',
  untilWhen bigint(20) unsigned default NULL,
  originalMode int(10) unsigned default NULL,
  admin varchar(255) default NULL,
  reason text,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Table structure for table `channelTypes`
--

CREATE TABLE channelTypes (
  channelTypeID int(10) unsigned NOT NULL default '0',
  channelTypeName varchar(64) NOT NULL default '',
  defaultName varchar(64) default NULL,
  PRIMARY KEY  (channelTypeID)
) TYPE=MyISAM;

--
-- Table structure for table `channels`
--

CREATE TABLE channels (
  channelID int(10) unsigned NOT NULL auto_increment,
  ownerID int(10) unsigned NOT NULL default '0',
  displayName varchar(255) default NULL,
  motd text,
  comparisonKey varchar(32) default NULL,
  memberless tinyint(4) NOT NULL default '0',
  password varchar(64) default NULL,
  mailingList tinyint(4) NOT NULL default '0',
  cspa tinyint(4) NOT NULL default '0',
  temporary tinyint(4) NOT NULL default '0',
  mode tinyint(4) NOT NULL default '0',
  subscribed tinyint(4) NOT NULL default '0',
  estimatedMemberCount int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (channelID)
) TYPE=MyISAM;

--
-- Table structure for table `character_`
--

CREATE TABLE character_ (
  characterID int(10) unsigned NOT NULL default '0',
  characterName varchar(127) NOT NULL default '',
  accountID int(10) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  description text NOT NULL,
  bounty double NOT NULL default '0',
  balance double NOT NULL default '0',
  securityRating double NOT NULL default '0',
  petitionMessage varchar(255) NOT NULL default '',
  logonMinutes int(10) unsigned NOT NULL default '0',
  corporationID int(10) unsigned NOT NULL default '0',
  corporationDateTime bigint(20) unsigned NOT NULL default '0',
  startDateTime bigint(20) unsigned NOT NULL default '0',
  createDateTime bigint(20) unsigned NOT NULL default '0',
  typeID int(10) unsigned NOT NULL default '0',
  raceID int(10) unsigned NOT NULL default '0',
  bloodlineID int(10) unsigned NOT NULL default '0',
  gender tinyint(4) NOT NULL default '0',
  accessoryID int(10) unsigned default NULL,
  beardID int(10) unsigned default NULL,
  costumeID int(10) unsigned NOT NULL default '0',
  decoID int(10) unsigned default NULL,
  eyebrowsID int(10) unsigned NOT NULL default '0',
  eyesID int(10) unsigned NOT NULL default '0',
  hairID int(10) unsigned NOT NULL default '0',
  lipstickID int(10) unsigned default NULL,
  makeupID int(10) unsigned default NULL,
  skinID int(10) unsigned NOT NULL default '0',
  backgroundID int(10) unsigned NOT NULL default '0',
  lightID int(10) unsigned NOT NULL default '0',
  headRotation1 double NOT NULL default '0',
  headRotation2 double NOT NULL default '0',
  headRotation3 double NOT NULL default '0',
  eyeRotation1 double NOT NULL default '0',
  eyeRotation2 double NOT NULL default '0',
  eyeRotation3 double NOT NULL default '0',
  camPos1 double NOT NULL default '0',
  camPos2 double NOT NULL default '0',
  camPos3 double NOT NULL default '0',
  morph1e double default NULL,
  morph1n double default NULL,
  morph1s double default NULL,
  morph1w double default NULL,
  morph2e double default NULL,
  morph2n double default NULL,
  morph2s double default NULL,
  morph2w double default NULL,
  morph3e double default NULL,
  morph3n double default NULL,
  morph3s double default NULL,
  morph3w double default NULL,
  morph4e double default NULL,
  morph4n double default NULL,
  morph4s double default NULL,
  morph4w double default NULL,
  stationID int(10) unsigned NOT NULL default '0',
  solarSystemID int(10) unsigned NOT NULL default '0',
  constellationID int(10) unsigned NOT NULL default '0',
  regionID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (characterID),
  UNIQUE KEY characterName (characterName)
) TYPE=MyISAM;

--
-- Table structure for table `corporation`
--

CREATE TABLE corporation (
  corporationID int(10) unsigned NOT NULL default '0',
  corporationName varchar(100) NOT NULL default '',
  description mediumtext NOT NULL,
  tickerName varchar(8) NOT NULL default '',
  url mediumtext NOT NULL,
  taxRate double NOT NULL default '0',
  minimumJoinStanding double NOT NULL default '0',
  corporationType int(10) unsigned NOT NULL default '0',
  hasPlayerPersonnelManager tinyint(3) unsigned NOT NULL default '0',
  sendCharTerminationMessage tinyint(3) unsigned NOT NULL default '0',
  creatorID int(10) unsigned NOT NULL default '0',
  ceoID int(10) unsigned NOT NULL default '0',
  stationID int(10) unsigned NOT NULL default '0',
  raceID int(10) unsigned default NULL,
  allianceID int(10) unsigned default NULL,
  shares int(10) unsigned NOT NULL default '0',
  memberCount int(10) unsigned NOT NULL default '0',
  memberLimit int(10) unsigned NOT NULL default '0',
  allowedMemberRaceIDs int(10) unsigned NOT NULL default '0',
  graphicID int(10) unsigned NOT NULL default '0',
  shape1 int(10) unsigned default NULL,
  shape2 int(10) unsigned default NULL,
  shape3 int(10) unsigned default NULL,
  color1 int(10) unsigned default NULL,
  color2 int(10) unsigned default NULL,
  color3 int(10) unsigned default NULL,
  typeface varchar(32) default NULL,
  division1 varchar(32) default NULL,
  division2 varchar(32) default NULL,
  division3 varchar(32) default NULL,
  division4 varchar(32) default NULL,
  division5 varchar(32) default NULL,
  division6 varchar(32) default NULL,
  division7 varchar(32) default NULL,
  PRIMARY KEY  (corporationID)
) TYPE=MyISAM;

--
-- Table structure for table `crpCharShares`
--

CREATE TABLE crpCharShares (
  characterID int(10) unsigned NOT NULL default '0',
  corporationID int(10) unsigned NOT NULL default '0',
  shares int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (characterID,corporationID)
) TYPE=MyISAM;

--
-- Table structure for table `droneState`
--

CREATE TABLE droneState (
  droneID int(10) unsigned NOT NULL default '0',
  solarSystemID int(10) unsigned NOT NULL default '0',
  ownerID int(10) unsigned NOT NULL default '0',
  controllerID int(10) unsigned NOT NULL default '0',
  activityState int(10) unsigned NOT NULL default '0',
  typeID int(10) unsigned NOT NULL default '0',
  controllerOwnerID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (droneID)
) TYPE=MyISAM;

--
-- Table structure for table `entity`
--

CREATE TABLE entity (
  itemID int(10) unsigned NOT NULL auto_increment,
  itemName varchar(255) NOT NULL default '',
  typeID int(10) unsigned NOT NULL default '0',
  ownerID int(10) unsigned NOT NULL default '0',
  locationID int(10) unsigned NOT NULL default '0',
  flag int(10) unsigned NOT NULL default '0',
  contraband int(10) unsigned NOT NULL default '0',
  singleton int(10) unsigned NOT NULL default '0',
  quantity int(10) unsigned NOT NULL default '0',
  x double NOT NULL default '0',
  y double NOT NULL default '0',
  z double NOT NULL default '0',
  customInfo text,
  PRIMARY KEY  (itemID)
) TYPE=MyISAM;

--
-- Table structure for table `evemail`
--

CREATE TABLE evemail (
  channelID int(10) unsigned NOT NULL default '0',
  messageID int(10) unsigned NOT NULL default '0',
  senderID int(10) unsigned NOT NULL default '0',
  subject varchar(64) NOT NULL default '',
  created int(10) unsigned NOT NULL default '0',
  read tinyint(3) unsigned NOT NULL default '0'
) TYPE=MyISAM;

--
-- Table structure for table `evemailDetails`
--

CREATE TABLE evemailDetails (
  attachmentID int(10) unsigned NOT NULL auto_increment,
  messageID int(10) unsigned NOT NULL default '0',
  mimeType text NOT NULL,
  attachment text NOT NULL,
  PRIMARY KEY  (attachmentID)
) TYPE=MyISAM;

--
-- Table structure for table `market_journal`
--

CREATE TABLE market_journal (
  characterID int(10) unsigned NOT NULL default '0',
  refID int(10) unsigned NOT NULL auto_increment,
  transDate bigint(20) default NULL,
  refTypeID int(10) unsigned NOT NULL default '0',
  ownerID1 int(10) unsigned NOT NULL default '0',
  ownerID2 int(10) unsigned NOT NULL default '0',
  argID1 varchar(64) default NULL,
  accountID int(10) unsigned NOT NULL default '0',
  amount double NOT NULL default '0',
  balance double NOT NULL default '0',
  reason varchar(128) default NULL,
  PRIMARY KEY  (refID)
) TYPE=MyISAM;

--
-- Table structure for table `market_orders`
--

CREATE TABLE market_orders (
  orderID int(10) unsigned NOT NULL auto_increment,
  typeID int(10) unsigned NOT NULL default '0',
  charID int(10) unsigned NOT NULL default '0',
  regionID int(10) unsigned NOT NULL default '0',
  stationID int(10) unsigned NOT NULL default '0',
  range int(10) unsigned NOT NULL default '0',
  bid double NOT NULL default '0',
  price double NOT NULL default '0',
  volEntered int(10) unsigned NOT NULL default '0',
  volRemaining int(10) unsigned NOT NULL default '0',
  issued int(10) unsigned NOT NULL default '0',
  orderState int(10) unsigned NOT NULL default '0',
  minVolume int(10) unsigned NOT NULL default '0',
  contraband tinyint(3) unsigned NOT NULL default '0',
  accountID int(10) unsigned NOT NULL default '0',
  duration int(10) unsigned NOT NULL default '0',
  isCorp tinyint(3) unsigned NOT NULL default '0',
  solarSystemID int(10) unsigned default NULL,
  escrow tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (orderID)
) TYPE=MyISAM;

--
-- Table structure for table `market_transactions`
--

CREATE TABLE market_transactions (
  transactionID int(10) unsigned NOT NULL auto_increment,
  transactionDateTime int(10) unsigned NOT NULL default '0',
  stationID int(10) unsigned NOT NULL default '0',
  typeID int(10) unsigned NOT NULL default '0',
  quantity int(10) unsigned NOT NULL default '0',
  price double NOT NULL default '0',
  transactionType int(10) unsigned NOT NULL default '0',
  clientID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (transactionID)
) TYPE=MyISAM;

--
-- Table structure for table `npcStandings`
--

CREATE TABLE npcStandings (
  fromID int(10) unsigned NOT NULL default '0',
  toID int(10) unsigned NOT NULL default '0',
  standing double NOT NULL default '0',
  PRIMARY KEY  (fromID,toID)
) TYPE=MyISAM;

--
-- Table structure for table `rentalInfo`
--

CREATE TABLE rentalInfo (
  stationID int(10) unsigned NOT NULL default '0',
  slotNumber int(10) unsigned NOT NULL default '0',
  renterID int(10) unsigned NOT NULL default '0',
  typeID int(10) unsigned NOT NULL default '0',
  rentPeriodInDays int(10) unsigned NOT NULL default '0',
  periodCost double NOT NULL default '0',
  billID int(10) unsigned NOT NULL default '0',
  balanceDueDate int(10) unsigned NOT NULL default '0',
  discontinue tinyint(3) unsigned NOT NULL default '0',
  publiclyAvailable tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (stationID,slotNumber)
) TYPE=MyISAM;

