-- MySQL dump 10.9
--
-- Host: 127.0.0.1    Database: eve
-- ------------------------------------------------------
-- Server version	4.1.22-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `account`
--

DROP TABLE IF EXISTS `account`;
CREATE TABLE `account` (
  `accountID` int(10) unsigned NOT NULL auto_increment,
  `accountName` varchar(43) NOT NULL default '',
  `password` varchar(43) NOT NULL default '',
  `role` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`accountID`),
  UNIQUE KEY `accountName` (`accountName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `alliance_shortnames`
--

DROP TABLE IF EXISTS `alliance_shortnames`;
CREATE TABLE `alliance_shortnames` (
  `allianceID` int(10) unsigned NOT NULL default '0',
  `shortName` text NOT NULL,
  PRIMARY KEY  (`allianceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `billsReceivable`
--

DROP TABLE IF EXISTS `billsReceivable`;
CREATE TABLE `billsReceivable` (
  `billID` int(10) unsigned NOT NULL default '0',
  `billTypeID` int(10) unsigned default NULL,
  `debtorID` int(10) unsigned default NULL,
  `creditorID` int(10) unsigned default NULL,
  `amount` text NOT NULL,
  `dueDateTime` text NOT NULL,
  `interest` text NOT NULL,
  `externalID` int(10) unsigned default NULL,
  `paid` text NOT NULL,
  `externalID2` text NOT NULL,
  PRIMARY KEY  (`billID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `bookmarks`
--

DROP TABLE IF EXISTS `bookmarks`;
CREATE TABLE `bookmarks` (
  `bookmarkID` int(10) unsigned NOT NULL default '0',
  `ownerID` int(10) unsigned NOT NULL default '0',
  `itemID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `flag` int(10) unsigned NOT NULL default '0',
  `memo` varchar(85) NOT NULL default '',
  `created` int(10) unsigned NOT NULL default '0',
  `x` double NOT NULL default '0',
  `y` double NOT NULL default '0',
  `z` double NOT NULL default '0',
  `locationID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`bookmarkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `channelChars`
--

DROP TABLE IF EXISTS `channelChars`;
CREATE TABLE `channelChars` (
  `channelID` int(10) unsigned NOT NULL default '0',
  `corpID` int(10) unsigned NOT NULL default '0',
  `charID` int(10) unsigned NOT NULL default '0',
  `allianceID` int(10) unsigned NOT NULL default '0',
  `role` int(10) unsigned NOT NULL default '0',
  `extra` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`channelID`,`charID`),
  KEY `FK_CHANNELCHARS_CHARACTER` (`charID`),
  KEY `FK_CHANNELCHARS_CORPORATIONS` (`corpID`),
  KEY `FK_CHANNELCHARS_ALLIANCES` (`allianceID`),
  CONSTRAINT `FK_CHANNELCHARS_ALLIANCES` FOREIGN KEY (`allianceID`) REFERENCES `alliance_shortnames` (`allianceID`),
  CONSTRAINT `FK_CHANNELCHARS_CHANNELS` FOREIGN KEY (`channelID`) REFERENCES `channels` (`channelID`),
  CONSTRAINT `FK_CHANNELCHARS_CHARACTER` FOREIGN KEY (`charID`) REFERENCES `character_` (`characterID`),
  CONSTRAINT `FK_CHANNELCHARS_CORPORATIONS` FOREIGN KEY (`corpID`) REFERENCES `corporation` (`corporationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `channelMods`
--

DROP TABLE IF EXISTS `channelMods`;
CREATE TABLE `channelMods` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `channelID` int(10) unsigned NOT NULL default '0',
  `accessor` int(10) unsigned default NULL,
  `mode` int(10) unsigned NOT NULL default '0',
  `untilWhen` bigint(20) unsigned default NULL,
  `originalMode` int(10) unsigned default NULL,
  `admin` varchar(85) default NULL,
  `reason` text,
  PRIMARY KEY  (`id`),
  KEY `FK_CHANNELMODS_CHANNELS` (`channelID`),
  CONSTRAINT `FK_CHANNELMODS_CHANNELS` FOREIGN KEY (`channelID`) REFERENCES `channels` (`channelID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `channelTypes`
--

DROP TABLE IF EXISTS `channelTypes`;
CREATE TABLE `channelTypes` (
  `channelTypeID` int(10) unsigned NOT NULL default '0',
  `channelTypeName` varchar(100) NOT NULL default '',
  `defaultName` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`channelTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `channels`
--

DROP TABLE IF EXISTS `channels`;
CREATE TABLE `channels` (
  `channelID` int(10) unsigned NOT NULL auto_increment,
  `ownerID` int(10) unsigned NOT NULL default '0',
  `displayName` varchar(85) default NULL,
  `motd` text,
  `comparisonKey` varchar(11) default NULL,
  `memberless` tinyint(4) NOT NULL default '0',
  `password` varchar(100) default NULL,
  `mailingList` tinyint(4) NOT NULL default '0',
  `cspa` tinyint(4) NOT NULL default '0',
  `temporary` tinyint(4) NOT NULL default '0',
  `mode` tinyint(4) NOT NULL default '0',
  `subscribed` tinyint(4) NOT NULL default '0',
  `estimatedMemberCount` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`channelID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `character_`
--

DROP TABLE IF EXISTS `character_`;
CREATE TABLE `character_` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `characterName` varchar(43) NOT NULL default '',
  `accountID` int(10) unsigned default NULL,
  `title` varchar(85) NOT NULL default '',
  `description` text NOT NULL,
  `bounty` double NOT NULL default '0',
  `balance` double NOT NULL default '0',
  `securityRating` double NOT NULL default '0',
  `petitionMessage` varchar(85) NOT NULL default '',
  `logonMinutes` int(10) unsigned NOT NULL default '0',
  `corporationID` int(10) unsigned NOT NULL default '0',
  `corporationDateTime` bigint(20) unsigned NOT NULL default '0',
  `startDateTime` bigint(20) unsigned NOT NULL default '0',
  `createDateTime` bigint(20) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `raceID` int(10) unsigned NOT NULL default '0',
  `bloodlineID` int(10) unsigned NOT NULL default '0',
  `gender` tinyint(4) NOT NULL default '0',
  `accessoryID` int(10) unsigned default NULL,
  `beardID` int(10) unsigned default NULL,
  `costumeID` int(10) unsigned NOT NULL default '0',
  `decoID` int(10) unsigned default NULL,
  `eyebrowsID` int(10) unsigned NOT NULL default '0',
  `eyesID` int(10) unsigned NOT NULL default '0',
  `hairID` int(10) unsigned NOT NULL default '0',
  `lipstickID` int(10) unsigned default NULL,
  `makeupID` int(10) unsigned default NULL,
  `skinID` int(10) unsigned NOT NULL default '0',
  `backgroundID` int(10) unsigned NOT NULL default '0',
  `lightID` int(10) unsigned NOT NULL default '0',
  `headRotation1` double NOT NULL default '0',
  `headRotation2` double NOT NULL default '0',
  `headRotation3` double NOT NULL default '0',
  `eyeRotation1` double NOT NULL default '0',
  `eyeRotation2` double NOT NULL default '0',
  `eyeRotation3` double NOT NULL default '0',
  `camPos1` double NOT NULL default '0',
  `camPos2` double NOT NULL default '0',
  `camPos3` double NOT NULL default '0',
  `morph1e` double default NULL,
  `morph1n` double default NULL,
  `morph1s` double default NULL,
  `morph1w` double default NULL,
  `morph2e` double default NULL,
  `morph2n` double default NULL,
  `morph2s` double default NULL,
  `morph2w` double default NULL,
  `morph3e` double default NULL,
  `morph3n` double default NULL,
  `morph3s` double default NULL,
  `morph3w` double default NULL,
  `morph4e` double default NULL,
  `morph4n` double default NULL,
  `morph4s` double default NULL,
  `morph4w` double default NULL,
  `stationID` int(10) unsigned NOT NULL default '0',
  `solarSystemID` int(10) unsigned NOT NULL default '0',
  `constellationID` int(10) unsigned NOT NULL default '0',
  `regionID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`characterID`),
  UNIQUE KEY `characterName` (`characterName`),
  KEY `FK_CHARACTER__ACCOUNTS` (`accountID`),
  KEY `FK_CHARACTER__INVTYPES` (`typeID`),
  KEY `FK_CHARACTER__CHRACCESSORIES` (`accessoryID`),
  KEY `FK_CHARACTER__CHRBEARDS` (`beardID`),
  KEY `FK_CHARACTER__CHRCOSTUMES` (`costumeID`),
  KEY `FK_CHARACTER__CHRDECOS` (`decoID`),
  KEY `FK_CHARACTER__CHREYEBROWS` (`eyebrowsID`),
  KEY `FK_CHARACTER__CHREYES` (`eyesID`),
  KEY `FK_CHARACTER__CHRHAIRS` (`hairID`),
  KEY `FK_CHARACTER__CHRLIPSTICKS` (`lipstickID`),
  KEY `FK_CHARACTER__CHRMAKEUPS` (`makeupID`),
  KEY `FK_CHARACTER__CHRSKINS` (`skinID`),
  KEY `FK_CHARACTER__CHRBACKGROUNDS` (`backgroundID`),
  KEY `FK_CHARACTER__CHRLIGHTS` (`lightID`),
  CONSTRAINT `FK_CHARACTER__ACCOUNTS` FOREIGN KEY (`accountID`) REFERENCES `account` (`accountID`),
  CONSTRAINT `FK_CHARACTER__CHRACCESSORIES` FOREIGN KEY (`accessoryID`) REFERENCES `chrAccessories` (`accessoryID`),
  CONSTRAINT `FK_CHARACTER__CHRBACKGROUNDS` FOREIGN KEY (`backgroundID`) REFERENCES `chrBackgrounds` (`backgroundID`),
  CONSTRAINT `FK_CHARACTER__CHRBEARDS` FOREIGN KEY (`beardID`) REFERENCES `chrBeards` (`beardID`),
  CONSTRAINT `FK_CHARACTER__CHRCOSTUMES` FOREIGN KEY (`costumeID`) REFERENCES `chrCostumes` (`costumeID`),
  CONSTRAINT `FK_CHARACTER__CHRDECOS` FOREIGN KEY (`decoID`) REFERENCES `chrDecos` (`decoID`),
  CONSTRAINT `FK_CHARACTER__CHREYEBROWS` FOREIGN KEY (`eyebrowsID`) REFERENCES `chrEyebrows` (`eyebrowsID`),
  CONSTRAINT `FK_CHARACTER__CHREYES` FOREIGN KEY (`eyesID`) REFERENCES `chrEyes` (`eyesID`),
  CONSTRAINT `FK_CHARACTER__CHRHAIRS` FOREIGN KEY (`hairID`) REFERENCES `chrHairs` (`hairID`),
  CONSTRAINT `FK_CHARACTER__CHRLIGHTS` FOREIGN KEY (`lightID`) REFERENCES `chrLights` (`lightID`),
  CONSTRAINT `FK_CHARACTER__CHRLIPSTICKS` FOREIGN KEY (`lipstickID`) REFERENCES `chrLipsticks` (`lipstickID`),
  CONSTRAINT `FK_CHARACTER__CHRMAKEUPS` FOREIGN KEY (`makeupID`) REFERENCES `chrMakeups` (`makeupID`),
  CONSTRAINT `FK_CHARACTER__CHRSKINS` FOREIGN KEY (`skinID`) REFERENCES `chrSkins` (`skinID`),
  CONSTRAINT `FK_CHARACTER__INVTYPES` FOREIGN KEY (`typeID`) REFERENCES `invTypes` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `chrEmployment`
--

DROP TABLE IF EXISTS `chrEmployment`;
CREATE TABLE `chrEmployment` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `corporationID` int(10) unsigned NOT NULL default '0',
  `startDate` bigint(20) unsigned NOT NULL default '0',
  `deleted` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`corporationID`,`startDate`),
  KEY `corporationID` (`corporationID`),
  CONSTRAINT `chrEmployment_ibfk_1` FOREIGN KEY (`characterID`) REFERENCES `character_` (`characterID`),
  CONSTRAINT `chrEmployment_ibfk_2` FOREIGN KEY (`corporationID`) REFERENCES `corporation` (`corporationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `chrStandings`
--

DROP TABLE IF EXISTS `chrStandings`;
CREATE TABLE `chrStandings` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `toID` int(10) unsigned NOT NULL default '0',
  `standing` double NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`toID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `chrMissionState`
--

DROP TABLE IF EXISTS `chrMissionState`;
CREATE TABLE `chrMissionState` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `missionID` int(10) unsigned NOT NULL default '0',
  `missionState` tinyint(3) unsigned NOT NULL default '0',
  `expirationTime` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`missionID`),
  KEY `missionID` (`missionID`),
  CONSTRAINT `chrMissionState_ibfk_1` FOREIGN KEY (`characterID`) REFERENCES `character_` (`characterID`),
  CONSTRAINT `chrMissionState_ibfk_2` FOREIGN KEY (`missionID`) REFERENCES `agtMissions` (`missionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `chrNPCStandings`
--

DROP TABLE IF EXISTS `chrNPCStandings`;
CREATE TABLE `chrNPCStandings` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `fromID` int(10) unsigned NOT NULL default '0',
  `standing` double NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`fromID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `chrOffers`
--

DROP TABLE IF EXISTS `chrOffers`;
CREATE TABLE `chrOffers` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `offerID` int(10) unsigned NOT NULL default '0',
  `expirationTime` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`offerID`),
  KEY `offerID` (`offerID`),
  CONSTRAINT `chrOffers_ibfk_1` FOREIGN KEY (`characterID`) REFERENCES `character_` (`characterID`),
  CONSTRAINT `chrOffers_ibfk_2` FOREIGN KEY (`offerID`) REFERENCES `agtOffers` (`offerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `corporation`
--

DROP TABLE IF EXISTS `corporation`;
CREATE TABLE `corporation` (
  `corporationID` int(10) unsigned NOT NULL auto_increment,
  `corporationName` varchar(100) NOT NULL default '',
  `description` mediumtext NOT NULL,
  `tickerName` varchar(8) NOT NULL default '',
  `url` mediumtext NOT NULL,
  `taxRate` double NOT NULL default '0',
  `minimumJoinStanding` double NOT NULL default '0',
  `corporationType` int(10) unsigned NOT NULL default '0',
  `hasPlayerPersonnelManager` tinyint(3) unsigned NOT NULL default '0',
  `sendCharTerminationMessage` tinyint(3) unsigned NOT NULL default '0',
  `creatorID` int(10) unsigned NOT NULL default '0',
  `ceoID` int(10) unsigned NOT NULL default '0',
  `stationID` int(10) unsigned NOT NULL default '0',
  `raceID` int(10) unsigned default NULL,
  `allianceID` int(10) unsigned default NULL,
  `shares` bigint(20) unsigned NOT NULL default '0',
  `memberCount` int(10) unsigned NOT NULL default '0',
  `memberLimit` int(10) unsigned NOT NULL default '0',
  `allowedMemberRaceIDs` int(10) unsigned NOT NULL default '0',
  `graphicID` int(10) unsigned NOT NULL default '0',
  `shape1` int(10) unsigned default NULL,
  `shape2` int(10) unsigned default NULL,
  `shape3` int(10) unsigned default NULL,
  `color1` int(10) unsigned default NULL,
  `color2` int(10) unsigned default NULL,
  `color3` int(10) unsigned default NULL,
  `typeface` varchar(11) default NULL,
  `division1` varchar(11) default NULL,
  `division2` varchar(11) default NULL,
  `division3` varchar(11) default NULL,
  `division4` varchar(11) default NULL,
  `division5` varchar(11) default NULL,
  `division6` varchar(11) default NULL,
  `division7` varchar(11) default NULL,
  PRIMARY KEY  (`corporationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `crpCharShares`
--

DROP TABLE IF EXISTS `crpCharShares`;
CREATE TABLE `crpCharShares` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `corporationID` int(10) unsigned NOT NULL default '0',
  `shares` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`characterID`,`corporationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `droneState`
--

DROP TABLE IF EXISTS `droneState`;
CREATE TABLE `droneState` (
  `droneID` int(10) unsigned NOT NULL default '0',
  `solarSystemID` int(10) unsigned NOT NULL default '0',
  `ownerID` int(10) unsigned NOT NULL default '0',
  `controllerID` int(10) unsigned NOT NULL default '0',
  `activityState` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `controllerOwnerID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`droneID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `entity`
--

DROP TABLE IF EXISTS `entity`;
CREATE TABLE `entity` (
  `itemID` int(10) unsigned NOT NULL auto_increment,
  `itemName` varchar(85) NOT NULL default '',
  `typeID` int(10) unsigned NOT NULL default '0',
  `ownerID` int(10) unsigned NOT NULL default '0',
  `locationID` int(10) unsigned NOT NULL default '0',
  `flag` int(10) unsigned NOT NULL default '0',
  `contraband` int(10) unsigned NOT NULL default '0',
  `singleton` int(10) unsigned NOT NULL default '0',
  `quantity` int(10) unsigned NOT NULL default '0',
  `x` double NOT NULL default '0',
  `y` double NOT NULL default '0',
  `z` double NOT NULL default '0',
  `customInfo` text,
  PRIMARY KEY  (`itemID`),
  KEY `typeID` (`typeID`),
  CONSTRAINT `entity_ibfk_1` FOREIGN KEY (`typeID`) REFERENCES `invTypes` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `entity_attributes`
--

DROP TABLE IF EXISTS `entity_attributes`;
CREATE TABLE `entity_attributes` (
  `itemID` int(10) unsigned NOT NULL default '0',
  `attributeID` int(10) unsigned NOT NULL default '0',
  `valueInt` int(10) unsigned default NULL,
  `valueFloat` double unsigned default NULL,
  PRIMARY KEY  (`itemID`,`attributeID`),
  KEY `attributeID` (`attributeID`),
  CONSTRAINT `entity_attributes_ibfk_1` FOREIGN KEY (`itemID`) REFERENCES `entity` (`itemID`),
  CONSTRAINT `entity_attributes_ibfk_2` FOREIGN KEY (`attributeID`) REFERENCES `dgmAttributeTypes` (`attributeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `evemail`
--

DROP TABLE IF EXISTS `evemail`;
CREATE TABLE `evemail` (
  `channelID` int(10) unsigned NOT NULL default '0',
  `messageID` int(10) unsigned NOT NULL auto_increment,
  `senderID` int(10) unsigned NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `created` bigint(20) unsigned NOT NULL default '0',
  `read` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`messageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `evemailDetails`
--

DROP TABLE IF EXISTS `evemailDetails`;
CREATE TABLE `evemailDetails` (
  `attachmentID` int(10) unsigned NOT NULL auto_increment,
  `messageID` int(10) unsigned NOT NULL default '0',
  `mimeTypeID` int(10) unsigned NOT NULL default '0',
  `attachment` text NOT NULL,
  PRIMARY KEY  (`attachmentID`),
  KEY `messageID` (`messageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `market_journal`
--

DROP TABLE IF EXISTS `market_journal`;
CREATE TABLE `market_journal` (
  `characterID` int(10) unsigned NOT NULL default '0',
  `refID` int(10) unsigned NOT NULL auto_increment,
  `transDate` bigint(20) default NULL,
  `refTypeID` int(10) unsigned NOT NULL default '0',
  `ownerID1` int(10) unsigned NOT NULL default '0',
  `ownerID2` int(10) unsigned NOT NULL default '0',
  `argID1` varchar(255) default NULL,
  `accountID` int(10) unsigned NOT NULL default '0',
  `amount` double NOT NULL default '0',
  `balance` double NOT NULL default '0',
  `reason` varchar(43) default NULL,
  PRIMARY KEY  (`refID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `market_orders`
--

DROP TABLE IF EXISTS `market_orders`;
CREATE TABLE `market_orders` (
  `orderID` int(10) unsigned NOT NULL auto_increment,
  `typeID` int(10) unsigned NOT NULL default '0',
  `charID` int(10) unsigned NOT NULL default '0',
  `regionID` int(10) unsigned NOT NULL default '0',
  `stationID` int(10) unsigned NOT NULL default '0',
  `range` int(10) unsigned NOT NULL default '0',
  `bid` double NOT NULL default '0',
  `price` double NOT NULL default '0',
  `volEntered` int(10) unsigned NOT NULL default '0',
  `volRemaining` int(10) unsigned NOT NULL default '0',
  `issued` int(10) unsigned NOT NULL default '0',
  `orderState` int(10) unsigned NOT NULL default '0',
  `minVolume` int(10) unsigned NOT NULL default '0',
  `contraband` tinyint(3) unsigned NOT NULL default '0',
  `accountID` int(10) unsigned NOT NULL default '0',
  `duration` int(10) unsigned NOT NULL default '0',
  `isCorp` tinyint(3) unsigned NOT NULL default '0',
  `solarSystemID` int(11) NOT NULL default '0',
  `escrow` tinyint(3) unsigned NOT NULL default '0',
  `isBuy` tinyint(4) NOT NULL default '0',
  `jumps` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`orderID`),
  KEY `typeID` (`typeID`),
  KEY `regionID` (`regionID`),
  KEY `stationID` (`stationID`),
  KEY `solarSystemID` (`solarSystemID`),
  KEY `regionID_2` (`regionID`),
  KEY `typeID_2` (`typeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `market_transactions`
--

DROP TABLE IF EXISTS `market_transactions`;
CREATE TABLE `market_transactions` (
  `transactionID` int(10) unsigned NOT NULL auto_increment,
  `transactionDateTime` int(10) unsigned NOT NULL default '0',
  `stationID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `quantity` int(10) unsigned NOT NULL default '0',
  `price` double NOT NULL default '0',
  `transactionType` int(10) unsigned NOT NULL default '0',
  `clientID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`transactionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `npcStandings`
--

DROP TABLE IF EXISTS `npcStandings`;
CREATE TABLE `npcStandings` (
  `fromID` int(10) unsigned NOT NULL default '0',
  `toID` int(10) unsigned NOT NULL default '0',
  `standing` double NOT NULL default '0',
  PRIMARY KEY  (`fromID`,`toID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `rentalInfo`
--

DROP TABLE IF EXISTS `rentalInfo`;
CREATE TABLE `rentalInfo` (
  `stationID` int(10) unsigned NOT NULL default '0',
  `slotNumber` int(10) unsigned NOT NULL default '0',
  `renterID` int(10) unsigned NOT NULL default '0',
  `typeID` int(10) unsigned NOT NULL default '0',
  `rentPeriodInDays` int(10) unsigned NOT NULL default '0',
  `periodCost` double NOT NULL default '0',
  `billID` int(10) unsigned NOT NULL default '0',
  `balanceDueDate` int(10) unsigned NOT NULL default '0',
  `discontinue` tinyint(3) unsigned NOT NULL default '0',
  `publiclyAvailable` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`stationID`,`slotNumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

